﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using System.Windows.Threading;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for ChequePayment.xaml
    /// </summary>
    public partial class ChequePayment : Window
    {
        public ChequePayment()
        {
            InitializeComponent();
            txtBankName.Focus();
            LoadCurrentOrderTotal();
        }

        private void LoadCurrentOrderTotal()
        {
            lblTotalAmount.Text = AppSession.CurrentOrders.Total.ToString("SGD 0.00");
        }

        private void btnConfirmPayment_Click(object sender, RoutedEventArgs e)
        {
            if (ValidateValues())
            {
                ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                  {
                      Action action = () =>
                      {
                          decimal paid = 0;
                          decimal.TryParse(txtPayment.Text.Trim(), out paid);

                          AppSession.CurrentOrders.PaidAmount = paid;
                          AppSession.CurrentOrders.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;
                          AppSession.CurrentOrders.IsShipToBillingAddress = true;
                          AppSession.CurrentOrders.OrderFrom = AppSession.OrderFrom;
                          AppSession.CurrentOrders.PaymentMethod = "Cheque";
                          AppSession.CurrentOrders.PaymentType = txtBankName.Text.Trim();
                          AppSession.CurrentOrders.TransactionReference = txtChequeNo.Text.Trim();
                          AppSession.CurrentOrders.PaymentStatus = (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total) ? "Completed" : "Pending";
                          AppSession.CurrentOrders.OrderStatus = "New";

                          int days = AppSession.CurrentOrders.OrdersDetailsList.Max(i => i.EarliestAvailableDays);
                          AppSession.CurrentOrders.EarliestAvailableDate = DateTime.Now.AddDays(days);

                          if (OrdersBL.Save(AppSession.CurrentOrders))
                          {
                              OrdersBL.GenerateInvoice(AppSession.CurrentOrders.UniqueID);
                              AppSession.CurrentOrders = OrdersBL.GetItem(AppSession.CurrentOrders.UniqueID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                              AppSession.UpdateOrderProductQty(AppSession.CurrentOrders);
                          }
                      };
                      Dispatcher.BeginInvoke(DispatcherPriority.Send, action);
                  });

                if (!result.OperationFailed)
                {
                    this.Tag = true;
                    this.Close();
                }
                else
                    MessageBox.Show(result.Error.Message);
            }

        }

        private bool ValidateValues()
        {
            if (!ValidationUtility.ValidateString(txtBankName.Text.Trim()))
            {
                MessageBox.Show("Please enter Bank Name", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                txtBankName.Focus();
                return false;
            }
            if (!ValidationUtility.ValidateString(txtChequeNo.Text.Trim()))
            {
                MessageBox.Show("Please enter Cheque No.", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                txtChequeNo.Focus();
                return false;
            }
            if (!ValidationUtility.ValidateDecimal(txtPayment.Text.Trim()))
            {
                MessageBox.Show("Please enter valid Amount", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                txtPayment.Focus();
                return false;
            }

            return true;
        }

        private void btnCancelPayment_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
